//+------------------------------------------------------------------+
//|                                       QuantumTradingIncludes.mqh |
//|               Copyright 2013-2025, Quantum Trading Software Ltd. |
//|                                   https://www.quantumtrading.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013-2025, Quantum Trading Software Ltd."
#property link      "https://www.quantumtrading.com"
#property strict

int TimeMinute(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.min);
  }
int TimeHour(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.hour);
  }
int TimeYear(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.year);
  }
int TimeMonth(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.mon);
  }
int TimeDay(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.day);
  }
int TimeDayOfYear(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.day_of_year);
  }

//+----------------------------------------------------------------------------+
//|                                                              mql4-http.mqh |
//+----------------------------------------------------------------------------+
//|                                                      Built by Sergey Lukin |
//|                                                    contact@sergeylukin.com |
//|                                                                            |
//| This libarry is highly based on following:                                 |
//|                                                                            |
//| - HTTP Wininet sample: http://codebase.mql4.com/8115                       |
//| - EasyXML parser: http://www.mql5.com/code/1998                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
 
#import "wininet.dll"
#define INTERNET_FLAG_NO_CACHE_WRITE    0x04000000
#define INTERNET_FLAG_PRAGMA_NOCACHE    0x00000100
#define INTERNET_FLAG_RELOAD            0x80000000
int InternetOpenW(
    string     sAgent,
    int        lAccessType,
    string     sProxyName="",
    string     sProxyBypass="",
    int     lFlags=0
);
int InternetOpenUrlW(
    int     hInternetSession,
    string     sUrl, 
    string     sHeaders="",
    int     lHeadersLength=0,
    uint     lFlags=(INTERNET_FLAG_NO_CACHE_WRITE | INTERNET_FLAG_PRAGMA_NOCACHE | INTERNET_FLAG_RELOAD),
    int     lContext=0 
);
int InternetReadFile(
    int     hFile,
    uchar  &   sBuffer[],
    int     lNumBytesToRead,
    int&     lNumberOfBytesRead
);
int InternetCloseHandle(
    int     hInet
);       
#import
 
int hSession_IEType;
int hSession_Direct;
int Internet_Open_Type_Preconfig = 0;
int Internet_Open_Type_Direct = 1;
 
int hSession(bool Direct)
{
    string InternetAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; Q312461)";
    
    if (Direct) 
    { 
        if (hSession_Direct == 0)
        {
            hSession_Direct = InternetOpenW(InternetAgent, Internet_Open_Type_Direct, "0", "0", 0);
        }
        
        return(hSession_Direct); 
    }
    else 
    {
        if (hSession_IEType == 0)
        {
           hSession_IEType = InternetOpenW(InternetAgent, Internet_Open_Type_Preconfig, "0", "0", 0);
        }
        
        return(hSession_IEType); 
    }
}
 
string httpGET(string strUrl)
{
   int handler = hSession(false);
   int response = InternetOpenUrlW(handler, strUrl);
   if (response == 0) 
        return(IntegerToString(false));
        
   uchar ch[100]; string toStr=""; int dwBytes, h=-1;
   while(InternetReadFile(response, ch, 100, dwBytes)) 
  {
    if (dwBytes<=0) break; toStr=toStr+CharArrayToString(ch, 0, dwBytes);
  }
  
  InternetCloseHandle(response);
  return toStr;
}

string URLEncode(string toCode) {
  int max = StringLen(toCode);

  string RetStr = "";
  for(int i=0;i<max;i++) {
    string c = StringSubstr(toCode,i,1);
    int  asc = StringGetCharacter(c, 0);

    if((asc > 47 && asc < 58) || (asc > 64 && asc < 91) || (asc > 96 && asc < 123)) 
      RetStr = RetStr+c;
    else if (asc == 32)
      RetStr = RetStr+"+";
    else {
      RetStr = RetStr+"%"+hex(asc);
    }
  }
  return (RetStr);
}
string hex(int i) {
   static string h =  "0123456789ABCDEF";
   string ret="";
   int a = i % 16;
   int b = (i-a)/16;
   if (b>15) ret = hex(b)+StringSubstr(h,a,1);
   else      ret = StringSubstr(h, b ,1)+StringSubstr(h,a,1);
   
   return (ret);
}
string getEnablerEmail(string accountEmail) {
   string emailGlobalVarPrefix = "qts_";
   string _enablerEmail = accountEmail;
   
   //search if email exists in the Global Variables
   for(int i = GlobalVariablesTotal() - 1; i >= 0; i--) {
      string varName = GlobalVariableName(i);
      //if found, set it as a Global Variable name with a prefix
      if(StringSubstr(varName,0,4) == emailGlobalVarPrefix) {
         _enablerEmail = StringSubstr(varName, 4);
         GlobalVariableGet(varName);
         Print(_enablerEmail);
         break;
      } else _enablerEmail = "";
   }
   
   return _enablerEmail;
}