//+------------------------------------------------------------------+
//|                                       QuantumTradingIncludes.mqh |
//|                         Copyright 2017, Quantum Trading Software |
//|                                           www.quantumtrading.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2017, Quantum Trading Software"
#property link      "www.quantumtrading.com"
//+------------------------------------------------------------------+
//| defines                                                          |
//+------------------------------------------------------------------+
// #define MacrosHello   "Hello, world!"
// #define MacrosYear    2010
//+------------------------------------------------------------------+
//| DLL imports                                                      |
//+------------------------------------------------------------------+
// #import "user32.dll"
//   int      SendMessageA(int hWnd,int Msg,int wParam,int lParam);
// #import "my_expert.dll"
//   int      ExpertRecalculate(int wParam,int lParam);
// #import
//+------------------------------------------------------------------+
//| EX5 imports                                                      |
//+------------------------------------------------------------------+
// #import "stdlib.ex5"
//   string ErrorDescription(int error_code);
// #import
//+------------------------------------------------------------------+
#import "QuantumTradingLibrary.dll"
   int test(int);
   string HASH2(string);
   string RESP2(long, string, string);
   string ENC2(string, string, int, int, int);
   string URL2(string, string, string, string);
#import
// #import
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| MQL4 Migration ENUMS                                             |
//+------------------------------------------------------------------+
ENUM_TIMEFRAMES TFMigrate(int timeframe)
  {
   switch(timeframe)
     {
      case 0: return(PERIOD_CURRENT);
      case 1: return(PERIOD_M1);
      case 5: return(PERIOD_M5);
      case 15: return(PERIOD_M15);
      case 30: return(PERIOD_M30);
      case 60: return(PERIOD_H1);
      case 240: return(PERIOD_H4);
      case 1440: return(PERIOD_D1);
      case 10080: return(PERIOD_W1);
      case 43200: return(PERIOD_MN1);
      
      case 2: return(PERIOD_M2);
      case 3: return(PERIOD_M3);
      case 4: return(PERIOD_M4);      
      case 6: return(PERIOD_M6);
      case 10: return(PERIOD_M10);
      case 12: return(PERIOD_M12);
      case 16385: return(PERIOD_H1);
      case 16386: return(PERIOD_H2);
      case 16387: return(PERIOD_H3);
      case 16388: return(PERIOD_H4);
      case 16390: return(PERIOD_H6);
      case 16392: return(PERIOD_H8);
      case 16396: return(PERIOD_H12);
      case 16408: return(PERIOD_D1);
      case 32769: return(PERIOD_W1);
      case 49153: return(PERIOD_MN1);      
      default: return(PERIOD_CURRENT);
     }
  }
//+------------------------------------------------------------------+
//| MQL4 Migration Functions                                         |
//+------------------------------------------------------------------+
int TimeMinuteMQL4(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.min);
  }
int TimeHourMQL4(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.hour);
  }
int TimeYearMQL4(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.year);
  }
int TimeMonthMQL4(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.mon);
  }
int TimeDayMQL4(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.day);
  }
int TimeDayOfYearMQL4(datetime date)
  {
   MqlDateTime tm;
   TimeToStruct(date,tm);
   return(tm.day_of_year);
  }
//+------------------------------------------------------------------+
//|                                                   TimeSeries.mqh |
//|                                        Copyright 2012, komposter |
//|                                         http://www.komposter.me/ |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, komposter"
#property link      "http://www.komposter.me/"
//+------------------------------------------------------------------+
//| iTime
//+------------------------------------------------------------------+
datetime iTimeQT(int bar)
  {
   if(bar<0) return(-1);

   datetime array[];
   if(CopyTime(_Symbol,_Period,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
datetime iTimeQT(string symbol,ENUM_TIMEFRAMES timeframe,int bar)
  {
   if(bar<0) return(-1);

   datetime array[];
   if(CopyTime(symbol,timeframe,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//| iTickVolume
//+------------------------------------------------------------------+
long iTickVolumeQT(string symbol,ENUM_TIMEFRAMES timeframe,int bar)
  {
   if(bar<0) return(-1);

   long array[];
   if(CopyTickVolume(symbol,timeframe,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }

//+------------------------------------------------------------------+
//| iRealVolume
//+------------------------------------------------------------------+
long iRealVolumeQT(string symbol,ENUM_TIMEFRAMES timeframe,int bar)
  {
   if(bar<0) return(-1);

   long array[];
   if(CopyRealVolume(symbol,timeframe,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//| iOpen
//+------------------------------------------------------------------+
double iOpenQT(int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyOpen(_Symbol,_Period,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double iOpenQT(string symbol,ENUM_TIMEFRAMES timeframe,int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyOpen(symbol,timeframe,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//| iHigh
//+------------------------------------------------------------------+
double iHighQT(int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyHigh(_Symbol,_Period,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double iHighQT(string symbol,ENUM_TIMEFRAMES timeframe,int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyHigh(symbol,timeframe,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//| iLow
//+------------------------------------------------------------------+
double iLowQT(int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyLow(_Symbol,_Period,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double iLowQT(string symbol,ENUM_TIMEFRAMES timeframe,int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyLow(symbol,timeframe,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//| iClose
//+------------------------------------------------------------------+
double iCloseQT(int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyClose(_Symbol,_Period,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double iCloseQT(string symbol,ENUM_TIMEFRAMES timeframe,int bar)
  {
   if(bar<0) return(-1);

   double array[];
   if(CopyClose(symbol,timeframe,bar,1,array)>0)
      return(array[0]);
   else
      return(-1);
  }
//+------------------------------------------------------------------+
//| iHighest
//+------------------------------------------------------------------+
int iHighestQT(int bar_left,int bar_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyHigh(_Symbol,_Period,bar_right,bar_left-bar_right+1,array);
   if(copied<0) return(-1);

   int highest_bar=-1; double highest=DBL_MIN;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]>highest)
        {
         highest=array[i];
         highest_bar=i;
        }
     }

   if(highest_bar<0) return(-1);

   return(bar_right+highest_bar);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iHighestQT(string symbol,ENUM_TIMEFRAMES timeframe,int bar_left,int bar_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyHigh(symbol,timeframe,bar_right,bar_left-bar_right+1,array);
   if(copied<0) return(-1);

   int highest_bar=-1; double highest=DBL_MIN;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]>highest)
        {
         highest=array[i];
         highest_bar=i;
        }
     }

   if(highest_bar<0) return(-1);

   return(bar_right+highest_bar);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iHighestQT(datetime time_left,datetime time_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyHigh(_Symbol,_Period,time_left,time_right,array);
   if(copied<0) return(-1);

   int highest_bar=-1; double highest=DBL_MIN;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]>highest)
        {
         highest=array[i];
         highest_bar=i;
        }
     }

   if(highest_bar<0) return(-1);

   return(highest_bar+iBarShift(_Symbol,_Period,time_right));
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iHighestQT(string symbol,ENUM_TIMEFRAMES timeframe,datetime time_left,datetime time_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyHigh(symbol,timeframe,time_left,time_right,array);
   if(copied<0) return(-1);

   int highest_bar=-1; double highest=DBL_MIN;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]>highest)
        {
         highest=array[i];
         highest_bar=i;
        }
     }

   if(highest_bar<0) return(-1);

   return(highest_bar+iBarShift(symbol,timeframe,time_right));
  }
//+------------------------------------------------------------------+
//| iLowest
//+------------------------------------------------------------------+
int iLowestQT(int bar_left,int bar_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyLow(_Symbol,_Period,bar_right,bar_left-bar_right+1,array);
   if(copied<0) return(-1);

   int lowest_bar=-1; double lowest=DBL_MAX;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]<lowest)
        {
         lowest=array[i];
         lowest_bar=i;
        }
     }

   if(lowest_bar<0) return(-1);

   return(bar_right+lowest_bar);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iLowestQT(string symbol,ENUM_TIMEFRAMES timeframe,int bar_left,int bar_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyLow(symbol,timeframe,bar_right,bar_left-bar_right+1,array);
   if(copied<0) return(-1);

   int lowest_bar=-1; double lowest=DBL_MAX;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]<lowest)
        {
         lowest=array[i];
         lowest_bar=i;
        }
     }

   if(lowest_bar<0) return(-1);

   return(bar_right+lowest_bar);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iLowestQT(datetime time_left,datetime time_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyLow(_Symbol,_Period,time_left,time_right,array);
   if(copied<0) return(-1);

   int lowest_bar=-1; double lowest=DBL_MAX;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]<lowest)
        {
         lowest=array[i];
         lowest_bar=i;
        }
     }

   if(lowest_bar<0) return(-1);

   return(lowest_bar+iBarShift(_Symbol,_Period,time_right));
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iLowestQT(string symbol,ENUM_TIMEFRAMES timeframe,datetime time_left,datetime time_right)
  {
   double array[]; ArraySetAsSeries(array,true);
   int copied=CopyLow(symbol,timeframe,time_left,time_right,array);
   if(copied<0) return(-1);

   int lowest_bar=-1; double lowest=DBL_MAX;
   for(int i=copied-1; i>=0; i --)
     {
      if(array[i]<lowest)
        {
         lowest=array[i];
         lowest_bar=i;
        }
     }

   if(lowest_bar<0) return(-1);

   return(lowest_bar+iBarShift(symbol,timeframe,time_right));
  }
//+------------------------------------------------------------------+
//| iBarShift
//+------------------------------------------------------------------+
int iBarShiftQT(datetime time,bool exact=false)
  {
   if(time<0) return(-1);

   datetime array[],time0;
   if(CopyTime(_Symbol,_Period,0,1,array)<0) return(-1);
   time0=array[0]; //Time of opening zero bar

   if(CopyTime(_Symbol,_Period,time0,time,array)<0) return(-1);

   datetime temptime=iTime(_Symbol,_Period,ArraySize(array)-1);
   if(array[0]==temptime && temptime<=time)
     {
      return(ArraySize(array)-1);
     }
   else
     {
      if(exact)
        {
         return(-1);
        }
      else
        {
         return(ArraySize(array)-1);
        }
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int iBarShiftQT(string symbol,ENUM_TIMEFRAMES timeframe,datetime time,bool exact=false)
  {
   if(time<0) return(-1);

   datetime array[],time0;
   if(CopyTime(symbol,timeframe,0,1,array)<0) return(-1);
   time0=array[0]; //Time of opening zero bar

   if(CopyTime(symbol,timeframe,time0,time,array)<0) return(-1);

   datetime temptime=iTime(symbol,timeframe,ArraySize(array)-1);
   if(array[0]==temptime && temptime<=time)
     {
      return(ArraySize(array)-1);
     }
   else
     {
      if(exact)
        {
         return(-1);
        }
      else
        {
         return(ArraySize(array)-1);
        }
     }
  }
//+------------------------------------------------------------------+
//+----------------------------------------------------------------------------+
//|                                                              mql4-http.mqh |
//+----------------------------------------------------------------------------+
//|                                                      Built by Sergey Lukin |
//|                                                    contact@sergeylukin.com |
//|                                                                            |
//| This libarry is highly based on following:                                 |
//|                                                                            |
//| - HTTP Wininet sample: http://codebase.mql4.com/8115                       |
//| - EasyXML parser: http://www.mql5.com/code/1998                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
 
#import "wininet.dll"
#define INTERNET_FLAG_NO_CACHE_WRITE    0x04000000
#define INTERNET_FLAG_PRAGMA_NOCACHE    0x00000100
#define INTERNET_FLAG_RELOAD            0x80000000
int InternetOpenW(
    string     sAgent,
    int        lAccessType,
    string     sProxyName="",
    string     sProxyBypass="",
    int     lFlags=0
);
int InternetOpenUrlW(
    int     hInternetSession,
    string     sUrl, 
    string     sHeaders="",
    int     lHeadersLength=0,
    uint     lFlags=(INTERNET_FLAG_NO_CACHE_WRITE | INTERNET_FLAG_PRAGMA_NOCACHE | INTERNET_FLAG_RELOAD),
    int     lContext=0 
);
int InternetReadFile(
    int     hFile,
    uchar  &   sBuffer[],
    int     lNumBytesToRead,
    int&     lNumberOfBytesRead
);
int InternetCloseHandle(
    int     hInet
);       
#import
 
int hSession_IEType;
int hSession_Direct;
int Internet_Open_Type_Preconfig = 0;
int Internet_Open_Type_Direct = 1;
 
int hSession(bool Direct)
{
    string InternetAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; Q312461)";
    
    if (Direct) 
    { 
        if (hSession_Direct == 0)
        {
            hSession_Direct = InternetOpenW(InternetAgent, Internet_Open_Type_Direct, "0", "0", 0);
        }
        
        return(hSession_Direct); 
    }
    else 
    {
        if (hSession_IEType == 0)
        {
           hSession_IEType = InternetOpenW(InternetAgent, Internet_Open_Type_Preconfig, "0", "0", 0);
        }
        
        return(hSession_IEType); 
    }
}
 
string httpGET(string strUrl)
{
   int handler = hSession(false);
   int response = InternetOpenUrlW(handler, strUrl);
   if (response == 0) 
        return(IntegerToString(false));
        
   uchar ch[100]; string toStr=""; int dwBytes, h=-1;
   while(InternetReadFile(response, ch, 100, dwBytes)) 
  {
    if (dwBytes<=0) break; toStr=toStr+CharArrayToString(ch, 0, dwBytes);
  }
  
  InternetCloseHandle(response);
  return toStr;
}
string UNICODE2ANSI(string s)
  {
   int leng,ipos;
   uchar m,d;
   ulong big;
   leng=StringLen(s);
   string unichar;
   string res="";
   if (leng!=0)
     {    
      unichar=" ";
      ipos=0;      
      while (ipos<leng)
        { //uchar typecasted because each double byte char is actually one byte
         m=uchar(StringGetCharacter(s,ipos));
         if (ipos+1<leng)
           d=uchar(StringGetCharacter(s,ipos+1));
         else
           d=0;
         big=d*256+m;                
         StringSetCharacter(unichar,0,ushort(big));         
         res = res+unichar;    
         ipos=ipos+2;
        }
     }
   return(res);
  }
string URLEncode(string toCode) {
  int max = StringLen(toCode);

  string RetStr = "";
  for(int i=0;i<max;i++) {
    string c = StringSubstr(toCode,i,1);
    int  asc = StringGetCharacter(c, 0);

    if((asc > 47 && asc < 58) || (asc > 64 && asc < 91) || (asc > 96 && asc < 123)) 
      RetStr = RetStr+c;
    else if (asc == 32)
      RetStr = RetStr+"+";
    else {
      RetStr = RetStr+"%"+hex(asc);
    }
  }
  return (RetStr);
}
string hex(int i) {
   static string h =  "0123456789ABCDEF";
   string ret="";
   int a = i % 16;
   int b = (i-a)/16;
   if (b>15) ret = hex(b)+StringSubstr(h,a,1);
   else      ret = StringSubstr(h, b ,1)+StringSubstr(h,a,1);
   
   return (ret);
}
string getEnablerEmail(string accountEmail) {
   string emailGlobalVarPrefix = "qts_";
   string _enablerEmail = "";
   
   //---- fetching enabler email
   if(accountEmail != "") {
      _enablerEmail = accountEmail;
      GlobalVariablesDeleteAll(emailGlobalVarPrefix);
      GlobalVariableSet(emailGlobalVarPrefix+_enablerEmail, 0);
   } else if(accountEmail == "") {
      //search if the email exists as a Global Variable
      for(int i = GlobalVariablesTotal() - 1; i >= 0; i--) {
         string varName = GlobalVariableName(i);
         //if found, set it as a Global Variable name with a prefix
         if(StringSubstr(varName,0,4) == emailGlobalVarPrefix && StringLen(varName) > 4) {
            GlobalVariableGet(varName);
            _enablerEmail = StringSubstr(varName, 4);
            break;
         } else _enablerEmail = "";
      }
   } else {
      //GlobalVariablesDeleteAll(emailGlobalVarPrefix);
      _enablerEmail = "";
   }
   
   return _enablerEmail;
}