//+------------------------------------------------------------------+
//|                                       QuantumTradingIncludes.mqh |
//|               Copyright 2013-2018, Quantum Trading Software Ltd. |
//|                                    http://www.quantumtrading.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013-2018, Quantum Trading Software Ltd."
#property link      "http://www.quantumtrading.com"
#property strict
//+------------------------------------------------------------------+
//| defines                                                          |
//+------------------------------------------------------------------+
// #define MacrosHello   "Hello, world!"
// #define MacrosYear    2010
//+------------------------------------------------------------------+
//| DLL imports                                                      |
//+------------------------------------------------------------------+
// #import "user32.dll"
//   int      SendMessageA(int hWnd,int Msg,int wParam,int lParam);
// #import "my_expert.dll"
//   int      ExpertRecalculate(int wParam,int lParam);
// #import

#import "QuantumTradingLibrary.dll"
   string ENC2(string, string, int, int, int);
   string HASH2(string);
   string RESP2(int, string, string);
   int test(int);
   string URL2(string, string, string, string);
#import

//+------------------------------------------------------------------+
//| EX5 imports                                                      |
//+------------------------------------------------------------------+
// #import "stdlib.ex5"
//   string ErrorDescription(int error_code);
// #import
//+------------------------------------------------------------------+

//+----------------------------------------------------------------------------+
//|                                                              mql4-http.mqh |
//+----------------------------------------------------------------------------+
//|                                                      Built by Sergey Lukin |
//|                                                    contact@sergeylukin.com |
//|                                                                            |
//| This libarry is highly based on following:                                 |
//|                                                                            |
//| - HTTP Wininet sample: http://codebase.mql4.com/8115                       |
//| - EasyXML parser: http://www.mql5.com/code/1998                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
 
#import "wininet.dll"
#define INTERNET_FLAG_NO_CACHE_WRITE    0x04000000
#define INTERNET_FLAG_PRAGMA_NOCACHE    0x00000100
#define INTERNET_FLAG_RELOAD            0x80000000
int InternetOpenW(
    string     sAgent,
    int        lAccessType,
    string     sProxyName="",
    string     sProxyBypass="",
    int     lFlags=0
);
int InternetOpenUrlW(
    int     hInternetSession,
    string     sUrl, 
    string     sHeaders="",
    int     lHeadersLength=0,
    uint     lFlags=(INTERNET_FLAG_NO_CACHE_WRITE | INTERNET_FLAG_PRAGMA_NOCACHE | INTERNET_FLAG_RELOAD),
    int     lContext=0 
);
int InternetReadFile(
    int     hFile,
    uchar  &   sBuffer[],
    int     lNumBytesToRead,
    int&     lNumberOfBytesRead
);
int InternetCloseHandle(
    int     hInet
);       
#import
 
int hSession_IEType;
int hSession_Direct;
int Internet_Open_Type_Preconfig = 0;
int Internet_Open_Type_Direct = 1;
 
int hSession(bool Direct)
{
    string InternetAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; Q312461)";
    
    if (Direct) 
    { 
        if (hSession_Direct == 0)
        {
            hSession_Direct = InternetOpenW(InternetAgent, Internet_Open_Type_Direct, "0", "0", 0);
        }
        
        return(hSession_Direct); 
    }
    else 
    {
        if (hSession_IEType == 0)
        {
           hSession_IEType = InternetOpenW(InternetAgent, Internet_Open_Type_Preconfig, "0", "0", 0);
        }
        
        return(hSession_IEType); 
    }
}
 
string httpGET(string strUrl)
{
   int handler = hSession(false);
   int response = InternetOpenUrlW(handler, strUrl);
   if (response == 0) 
        return(IntegerToString(false));
        
   uchar ch[100]; string toStr=""; int dwBytes, h=-1;
   while(InternetReadFile(response, ch, 100, dwBytes)) 
  {
    if (dwBytes<=0) break; toStr=toStr+CharArrayToString(ch, 0, dwBytes);
  }
  
  InternetCloseHandle(response);
  return toStr;
}

//+------------------------------------------------------------------+
//|                                                    stringlib.mqh |
//|                                       Copyright Bogdan Caramalac |
//|                                           http://mqlmagazine.com |
//+------------------------------------------------------------------+
string ANSI2UNICODE(string s)
  {
   ushort mychar;
   long m,d;
   double mm,dd;
   string img;    
   string res="";
   if (StringLen(s)>0)
     {
      string g=" ";
      for (int i=0;i<StringLen(s);i++)
         {          
          string f="  ";          
          mychar=ushort(StringGetCharacter(s,i));
          mm=MathMod(mychar,256);
          img=DoubleToString(mm,0);
          m=StringToInteger(img);
          dd=(mychar-m)/256.0;
          img=DoubleToString(dd,0);
          d=StringToInteger(img);
          if (m!=0)
            {
             StringSetCharacter(f,0,ushort(m));
             StringSetCharacter(f,1,ushort(d));
             res = StringConcatenate(res,f);
            }//if (m!=0)
          else
            break;                      
         }//for (int i=0;i<StringLen(s);i++)
      }//if (StringLen(s)>0)
   return(res);
  }
 
string UNICODE2ANSI(string s)
  {
   int leng,ipos;
   uchar m,d;
   ulong big;
   leng=StringLen(s);
   string unichar;
   string res="";
   if (leng!=0)
     {    
      unichar=" ";
      ipos=0;      
      while (ipos<leng)
        { //uchar typecasted because each double byte char is actually one byte
         m=uchar(StringGetCharacter(s,ipos));
         if (ipos+1<leng)
           d=uchar(StringGetCharacter(s,ipos+1));
         else
           d=0;
         big=d*256+m;                
         StringSetCharacter(unichar,0,ushort(big));         
         res = StringConcatenate(res,unichar);    
         ipos=ipos+2;
        }
     }
   return(res);
  }
string URLEncode(string toCode) {
  int max = StringLen(toCode);

  string RetStr = "";
  for(int i=0;i<max;i++) {
    string c = StringSubstr(toCode,i,1);
    int  asc = StringGetChar(c, 0);

    if((asc > 47 && asc < 58) || (asc > 64 && asc < 91) || (asc > 96 && asc < 123)) 
      RetStr = StringConcatenate(RetStr,c);
    else if (asc == 32)
      RetStr = StringConcatenate(RetStr,"+");
    else {
      RetStr = StringConcatenate(RetStr,"%",hex(asc));
    }
  }
  return (RetStr);
}

string hex(int i) {
   static string h =  "0123456789ABCDEF";
   string ret="";
   int a = i % 16;
   int b = (i-a)/16;
   if (b>15) ret = StringConcatenate(hex(b), StringSubstr(h,a,1));
   else      ret = StringConcatenate(StringSubstr(h, b ,1), StringSubstr(h,a,1));
   
   return (ret);
}
string getEnablerEmail(string accountEmail) {
   string emailGlobalVarPrefix = "qts_";
   string _enablerEmail = accountEmail;
   
   //search if email exists in the Global Variables
   for(int i = GlobalVariablesTotal() - 1; i >= 0; i--) {
      string varName = GlobalVariableName(i);
      //if found, set it as a Global Variable name with a prefix
      if(StringSubstr(varName,0,4) == emailGlobalVarPrefix) {
         _enablerEmail = StringSubstr(varName, 4);
         GlobalVariableGet(varName);
         Print(_enablerEmail);
         break;
      } else _enablerEmail = "";
   }
   
   return _enablerEmail;
}